// UNO

#include "DHT.h"

#define DHTTYPE DHT11

#define DHTPIN 6 // 메인보드 소켓 1번에 연결된 경우

DHT dht(DHTPIN, DHTTYPE);

int fan_input = 8;

#define measurePin A0     // 먼지 측정 센서 A1핀으로 지정

#define SensorLED 5       // 먼지 감지를 위한 적외선 LED A0번핀으로 지정

int Time1 = 280;    // Time1을 280으로 설정

int Time2 = 40;     // Time2을 40으로 설정

int Time3 = 9680;   // Time3을 9690으로 설정

String temp_11 = "", humi_11 = "", fan_str = "", dust_str = "";  


float t, h, dustDensity;

int trigger = 0;

bool window_flag = false;


bool data_flag = false;

String str_sensor = "", str_alarm = "", str_auto = "", len_check = "";

unsigned long prev_time, prev_time2, prev_time3, prev_time4;

char chr_recv;

String str_recv;

int chr_recv2;

int val_a, auto01, auto02, auto03, auto04, auto05, auto06, auto07, auto08;

String gpioState[] = {"false", "false", "false", "false", "false", "false", "false", "false"};

//boolean gpioState[] = {false, false, false, false, false, false, false, false};


void setup () {

  Serial.begin(500000);

  Serial.setTimeout(250);


  dht.begin();

  pinMode(fan_input, OUTPUT);

  pinMode(SensorLED, OUTPUT);  // SensorLED 핀(D2)을 출력 단자로 설정

  pinMode(measurePin, INPUT);

}


void loop() {

  getDHT11();

  getDust();


  if (!data_flag) {

  // 실시간 센서

    sensor_start(); // 페이로드 시작

    sensor("Humi", humi_11);

    sensor("Temp", temp_11);

    sensor("Dust", dust_str);

    sensor_end(); // 페이로드 끝

    send_sensor(1000); // 1초마다 전송

  // ----------------

  // 실시간 알람

  /*

    alarm_start();

    alarm("under01_UNO", temp_11);

    alarm("under02_UNO", soil);

    alarm("over01_UNO", temp_11);

    alarm("over02_UNO", Co2);

    alarm("under03_UNO", cds);

    alarm_end();

    send_alarm(3200);

  */

    send_autoState(2000);

  }

   

  // -----------------

  // 수동 제어

  if ( Serial.available() > 0 ) {

    chr_recv = Serial.read();

    str_recv = Serial.readString();

    chr_recv2 = str_recv.toInt();

    //recv_start();

    Serial.println(chr_recv2);


    if ( recv(3) ) {

      ON(fan_input, 1);

    } else if ( recv(4) ) {

      OFF(fan_input, 1);

    }

    auto_start();

  }

// --------------------------------------

// 자동 제어


  //if ( trigger == 1 ) {

    if ((millis() - prev_time ) >= 5000) {

      if ( trigger == 1 ) {

      //Serial.println(trigger);

   

      if ( recv_auto(auto01) ) {

        if ( dustDensity > auto01 ) {

          ON(fan_input, 1);

        } else if ( dustDensity <= auto01 ) {

          OFF(fan_input, 1);

        }

      }

      //prev_time = millis();

    }

    prev_time = millis();

  }

}


void getDHT11() {

  t = dht.readTemperature();

  h = dht.readHumidity();

  temp_11 = String(t, 1);

  humi_11 = String(h, 1);

}


void getDust() {

  digitalWrite(SensorLED, LOW);               // SensorLED를 LOW로 설정

  delayMicroseconds(Time1);                    // 280μs 지연

  float voMeasured = analogRead(measurePin);   // 센서에서 측정된 순수 아날로그값을 voMeasured 변수에 저장

  delayMicroseconds(Time2);                    // 40μs 지연

  digitalWrite(SensorLED, HIGH);               // SensorLED를 HIGH로 설정

  delayMicroseconds(Time3);                    // 9680μs 지연


  float calcVoltage = voMeasured * (5.0 / 1024.0);       // voMeasured의 값을 5/1024 와 곱하여 calcVoltage에 저장

  dustDensity = (calcVoltage - 0.15)/0.005; // calcVoltage 값에 0.17을 곱하고 -0.1을 더함

  dust_str = String(dustDensity);

}



/*

        하단 코드는 임의 수정 금지.

*/

void sensor_start() { str_sensor = "!,"; }

void sensor(String key, String value) {

  if ( value.length() > 0 ) {

    str_sensor += key; str_sensor += ":"; str_sensor += ",";

    str_sensor += value; str_sensor += ",";

  } else if ( value.length() == 0 ) {}

}

void sensor_end() { str_sensor += "@\n"; }

void send_sensor(int msec) {

  if ((millis() - prev_time2) >= msec) {

    Serial.write(str_sensor.c_str());

    prev_time2 = millis();

  }

}

void alarm_start() { str_alarm = "#,"; }

void alarm(String key, String value) {

  if ( value.length() > 0 ) {

    str_alarm += key; str_alarm += ":";

    str_alarm += value; str_alarm += ",";

  } else if ( value.length() == 0 ) {}

}

void alarm_end() { str_alarm += "$\n"; }

void send_alarm(int msec) {

  if ((millis() - prev_time3) >= msec) {

    Serial.write(str_alarm.c_str());

    prev_time3 = millis();

  }

}


void send_autoState(int msec) {

  str_auto = "&,";

  str_auto += "0:"; str_auto += ","; str_auto += gpioState[0]; str_auto += ",";

  str_auto += "1:"; str_auto += ","; str_auto += gpioState[1]; str_auto += ",";

  str_auto += "2:"; str_auto += ","; str_auto += gpioState[2]; str_auto += ",";

  str_auto += "*\n";

  if (( millis() - prev_time4 ) >= msec) {

    Serial.write(str_auto.c_str());

    prev_time4 = millis();

  }

}


void null_sensor() { str_sensor += ","; }

void null_alarm() { str_alarm += ","; }

void null_auto() { str_auto += ","; str_auto += ","; }


//char recv_start() {

   

//    return chr_recv;

//}



bool recv(int num) {

  if ( chr_recv == 'a') {

    trigger = 0;

    //data_flag = false;

    if ( chr_recv2 == num ) {

      return true;

    } else { return false; }

  } else { return false; }

}


void auto_start() {

  //if (data_flag) {

    if ( chr_recv == 'b' ) {

      auto01 = chr_recv2; trigger = 0;

      Serial.println("auto01 ");

      Serial.println(auto01);

      delay(500);

      trigger = 1;

    }

    else if ( chr_recv == 'c' ) {

      auto02 = chr_recv2; trigger = 0;

      Serial.println("auto02 ");

    }

    else if ( chr_recv == 'd' ) {

      auto03 = chr_recv2;

      Serial.println("auto03 ");

    }

    else if ( chr_recv == 'e' ) {

      auto04 = chr_recv2;

      Serial.println("auto04 ");

    }

    else if ( chr_recv == 'f' ) {

      auto05 = chr_recv2;

      Serial.println("auto05 ");

    }

    else if ( chr_recv == 'g' ) {

      auto06 = chr_recv2;

      Serial.println("auto06 ");

    }

    else if ( chr_recv == 'h' ) {

      auto07 = chr_recv2;

      Serial.println("auto07 ");

    }

    else if ( chr_recv == 'i' ) {

      auto08 = chr_recv2;

      Serial.println("auto08 ");

      trigger = 1;

      //data_flag = false;

    }

  //}

}

bool recv_auto(int val) {

  if ( val == 999 ) {

    return false;

  } else { return true; }

}

void ON(int pin, int num) {

  digitalWrite(pin, HIGH);

  gpioState[num] = "true";

  delay(50);

}

void OFF(int pin, int num) {

  digitalWrite(pin, LOW);

  gpioState[num] = "false";

  delay(50);

}
